package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteGraphqlApiRequest(apiId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest = {
    import DeleteGraphqlApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DeleteGraphqlApiRequest.ReadOnly =
    zio.aws.appsync.model.DeleteGraphqlApiRequest.wrap(buildAwsValue())
}
object DeleteGraphqlApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DeleteGraphqlApiRequest =
      zio.aws.appsync.model.DeleteGraphqlApiRequest(apiId)
    def apiId: String
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest
  ) extends zio.aws.appsync.model.DeleteGraphqlApiRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest
  ): zio.aws.appsync.model.DeleteGraphqlApiRequest.ReadOnly = new Wrapper(impl)
}
