package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LambdaConflictHandlerConfig(
    lambdaConflictHandlerArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.LambdaConflictHandlerConfig = {
    import LambdaConflictHandlerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.LambdaConflictHandlerConfig
      .builder()
      .optionallyWith(
        lambdaConflictHandlerArn.map(value => value: java.lang.String)
      )(_.lambdaConflictHandlerArn)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.LambdaConflictHandlerConfig.ReadOnly =
    zio.aws.appsync.model.LambdaConflictHandlerConfig.wrap(buildAwsValue())
}
object LambdaConflictHandlerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.LambdaConflictHandlerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.LambdaConflictHandlerConfig =
      zio.aws.appsync.model.LambdaConflictHandlerConfig(
        lambdaConflictHandlerArn.map(value => value)
      )
    def lambdaConflictHandlerArn: Optional[String]
    def getLambdaConflictHandlerArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("lambdaConflictHandlerArn", lambdaConflictHandlerArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.LambdaConflictHandlerConfig
  ) extends zio.aws.appsync.model.LambdaConflictHandlerConfig.ReadOnly {
    override val lambdaConflictHandlerArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaConflictHandlerArn())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.LambdaConflictHandlerConfig
  ): zio.aws.appsync.model.LambdaConflictHandlerConfig.ReadOnly = new Wrapper(
    impl
  )
}
