package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListFunctionsResponse(
    functions: Optional[Iterable[zio.aws.appsync.model.FunctionConfiguration]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListFunctionsResponse = {
    import ListFunctionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListFunctionsResponse
      .builder()
      .optionallyWith(
        functions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.functions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListFunctionsResponse.ReadOnly =
    zio.aws.appsync.model.ListFunctionsResponse.wrap(buildAwsValue())
}
object ListFunctionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListFunctionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListFunctionsResponse =
      zio.aws.appsync.model.ListFunctionsResponse(
        functions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def functions
        : Optional[List[zio.aws.appsync.model.FunctionConfiguration.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getFunctions: ZIO[Any, AwsError, List[
      zio.aws.appsync.model.FunctionConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("functions", functions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListFunctionsResponse
  ) extends zio.aws.appsync.model.ListFunctionsResponse.ReadOnly {
    override val functions
        : Optional[List[zio.aws.appsync.model.FunctionConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.functions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appsync.model.FunctionConfiguration.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListFunctionsResponse
  ): zio.aws.appsync.model.ListFunctionsResponse.ReadOnly = new Wrapper(impl)
}
