package zio.aws.appsync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appsync.model.primitives.{MaxResults, PaginationToken}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTypesRequest(
    apiId: String,
    format: zio.aws.appsync.model.TypeDefinitionFormat,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListTypesRequest = {
    import ListTypesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListTypesRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .format(format.unwrap)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListTypesRequest.ReadOnly =
    zio.aws.appsync.model.ListTypesRequest.wrap(buildAwsValue())
}
object ListTypesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListTypesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListTypesRequest =
      zio.aws.appsync.model.ListTypesRequest(
        apiId,
        format,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def apiId: String
    def format: zio.aws.appsync.model.TypeDefinitionFormat
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getFormat
        : ZIO[Any, Nothing, zio.aws.appsync.model.TypeDefinitionFormat] =
      ZIO.succeed(format)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListTypesRequest
  ) extends zio.aws.appsync.model.ListTypesRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val format: zio.aws.appsync.model.TypeDefinitionFormat =
      zio.aws.appsync.model.TypeDefinitionFormat.wrap(impl.format())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appsync.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListTypesRequest
  ): zio.aws.appsync.model.ListTypesRequest.ReadOnly = new Wrapper(impl)
}
