package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait SchemaStatus {
  def unwrap: software.amazon.awssdk.services.appsync.model.SchemaStatus
}
object SchemaStatus {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.SchemaStatus
  ): zio.aws.appsync.model.SchemaStatus = value match {
    case software.amazon.awssdk.services.appsync.model.SchemaStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.SchemaStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.appsync.model.SchemaStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.appsync.model.SchemaStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.appsync.model.SchemaStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.appsync.model.SchemaStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.appsync.model.SchemaStatus.NOT_APPLICABLE =>
      val r = NOT_APPLICABLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.SchemaStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.SchemaStatus =
      software.amazon.awssdk.services.appsync.model.SchemaStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PROCESSING extends zio.aws.appsync.model.SchemaStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.SchemaStatus =
      software.amazon.awssdk.services.appsync.model.SchemaStatus.PROCESSING
  }
  case object ACTIVE extends zio.aws.appsync.model.SchemaStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.SchemaStatus =
      software.amazon.awssdk.services.appsync.model.SchemaStatus.ACTIVE
  }
  case object DELETING extends zio.aws.appsync.model.SchemaStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.SchemaStatus =
      software.amazon.awssdk.services.appsync.model.SchemaStatus.DELETING
  }
  case object FAILED extends zio.aws.appsync.model.SchemaStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.SchemaStatus =
      software.amazon.awssdk.services.appsync.model.SchemaStatus.FAILED
  }
  case object SUCCESS extends zio.aws.appsync.model.SchemaStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.SchemaStatus =
      software.amazon.awssdk.services.appsync.model.SchemaStatus.SUCCESS
  }
  case object NOT_APPLICABLE extends zio.aws.appsync.model.SchemaStatus {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.SchemaStatus =
      software.amazon.awssdk.services.appsync.model.SchemaStatus.NOT_APPLICABLE
  }
}
