package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.Blob
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartSchemaCreationRequest(apiId: String, definition: Blob) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest = {
    import StartSchemaCreationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .definition(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(definition.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.StartSchemaCreationRequest.ReadOnly =
    zio.aws.appsync.model.StartSchemaCreationRequest.wrap(buildAwsValue())
}
object StartSchemaCreationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.StartSchemaCreationRequest =
      zio.aws.appsync.model.StartSchemaCreationRequest(apiId, definition)
    def apiId: String
    def definition: Blob
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getDefinition: ZIO[Any, Nothing, Blob] = ZIO.succeed(definition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest
  ) extends zio.aws.appsync.model.StartSchemaCreationRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val definition: Blob = zio.aws.appsync.model.primitives
      .Blob(zio.Chunk.fromArray(impl.definition().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest
  ): zio.aws.appsync.model.StartSchemaCreationRequest.ReadOnly = new Wrapper(
    impl
  )
}
