package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{TagValue, TagKey, ResourceArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.TagResourceRequest.ReadOnly =
    zio.aws.appsync.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.TagResourceRequest =
      zio.aws.appsync.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ResourceArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.TagResourceRequest
  ) extends zio.aws.appsync.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.appsync.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.appsync.model.primitives
          .TagKey(key) -> zio.aws.appsync.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.TagResourceRequest
  ): zio.aws.appsync.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
