package zio.aws.appsync.model
import scala.jdk.CollectionConverters._
sealed trait TypeDefinitionFormat {
  def unwrap: software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat
}
object TypeDefinitionFormat {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat
  ): zio.aws.appsync.model.TypeDefinitionFormat = value match {
    case software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat.SDL =>
      val r = SDL
      r
    case software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat.JSON =>
      val r = JSON
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appsync.model.TypeDefinitionFormat {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat =
      software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object SDL extends zio.aws.appsync.model.TypeDefinitionFormat {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat =
      software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat.SDL
  }
  case object JSON extends zio.aws.appsync.model.TypeDefinitionFormat {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat =
      software.amazon.awssdk.services.appsync.model.TypeDefinitionFormat.JSON
  }
}
