package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateGraphqlApiResponse(
    graphqlApi: Optional[zio.aws.appsync.model.GraphqlApi] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse = {
    import UpdateGraphqlApiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse
      .builder()
      .optionallyWith(graphqlApi.map(value => value.buildAwsValue()))(
        _.graphqlApi
      )
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateGraphqlApiResponse.ReadOnly =
    zio.aws.appsync.model.UpdateGraphqlApiResponse.wrap(buildAwsValue())
}
object UpdateGraphqlApiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateGraphqlApiResponse =
      zio.aws.appsync.model
        .UpdateGraphqlApiResponse(graphqlApi.map(value => value.asEditable))
    def graphqlApi: Optional[zio.aws.appsync.model.GraphqlApi.ReadOnly]
    def getGraphqlApi
        : ZIO[Any, AwsError, zio.aws.appsync.model.GraphqlApi.ReadOnly] =
      AwsError.unwrapOptionField("graphqlApi", graphqlApi)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse
  ) extends zio.aws.appsync.model.UpdateGraphqlApiResponse.ReadOnly {
    override val graphqlApi
        : Optional[zio.aws.appsync.model.GraphqlApi.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.graphqlApi())
        .map(value => zio.aws.appsync.model.GraphqlApi.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse
  ): zio.aws.appsync.model.UpdateGraphqlApiResponse.ReadOnly = new Wrapper(impl)
}
