package zio.aws.appsync.model
import scala.jdk.CollectionConverters.*
sealed trait AuthorizationType {
  def unwrap: software.amazon.awssdk.services.appsync.model.AuthorizationType
}
object AuthorizationType {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.AuthorizationType
  ): zio.aws.appsync.model.AuthorizationType = value match {
    case software.amazon.awssdk.services.appsync.model.AuthorizationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.AuthorizationType.AWS_IAM =>
      val r = AWS_IAM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.appsync.model.AuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AuthorizationType =
      software.amazon.awssdk.services.appsync.model.AuthorizationType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_IAM extends zio.aws.appsync.model.AuthorizationType {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.AuthorizationType =
      software.amazon.awssdk.services.appsync.model.AuthorizationType.AWS_IAM
  }
}
