package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateApiKeyResponse(
    apiKey: Optional[zio.aws.appsync.model.ApiKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse = {
    import CreateApiKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse
      .builder()
      .optionallyWith(apiKey.map(value => value.buildAwsValue()))(_.apiKey)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.CreateApiKeyResponse.ReadOnly =
    zio.aws.appsync.model.CreateApiKeyResponse.wrap(buildAwsValue())
}
object CreateApiKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.CreateApiKeyResponse =
      zio.aws.appsync.model
        .CreateApiKeyResponse(apiKey.map(value => value.asEditable))
    def apiKey: Optional[zio.aws.appsync.model.ApiKey.ReadOnly]
    def getApiKey: ZIO[Any, AwsError, zio.aws.appsync.model.ApiKey.ReadOnly] =
      AwsError.unwrapOptionField("apiKey", apiKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse
  ) extends zio.aws.appsync.model.CreateApiKeyResponse.ReadOnly {
    override val apiKey: Optional[zio.aws.appsync.model.ApiKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apiKey())
        .map(value => zio.aws.appsync.model.ApiKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse
  ): zio.aws.appsync.model.CreateApiKeyResponse.ReadOnly = new Wrapper(impl)
}
