package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateApiRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.DisassociateApiRequest = {
    import DisassociateApiRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.DisassociateApiRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.DisassociateApiRequest.ReadOnly =
    zio.aws.appsync.model.DisassociateApiRequest.wrap(buildAwsValue())
}
object DisassociateApiRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.DisassociateApiRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.DisassociateApiRequest =
      zio.aws.appsync.model.DisassociateApiRequest(domainName)
    def domainName: DomainName
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.DisassociateApiRequest
  ) extends zio.aws.appsync.model.DisassociateApiRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.appsync.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.DisassociateApiRequest
  ): zio.aws.appsync.model.DisassociateApiRequest.ReadOnly = new Wrapper(impl)
}
