package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ElasticsearchDataSourceConfig(
    endpoint: String,
    awsRegion: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ElasticsearchDataSourceConfig = {
    import ElasticsearchDataSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ElasticsearchDataSourceConfig
      .builder()
      .endpoint(endpoint: java.lang.String)
      .awsRegion(awsRegion: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly =
    zio.aws.appsync.model.ElasticsearchDataSourceConfig.wrap(buildAwsValue())
}
object ElasticsearchDataSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ElasticsearchDataSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ElasticsearchDataSourceConfig =
      zio.aws.appsync.model.ElasticsearchDataSourceConfig(endpoint, awsRegion)
    def endpoint: String
    def awsRegion: String
    def getEndpoint: ZIO[Any, Nothing, String] = ZIO.succeed(endpoint)
    def getAwsRegion: ZIO[Any, Nothing, String] = ZIO.succeed(awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ElasticsearchDataSourceConfig
  ) extends zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly {
    override val endpoint: String = impl.endpoint(): String
    override val awsRegion: String = impl.awsRegion(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ElasticsearchDataSourceConfig
  ): zio.aws.appsync.model.ElasticsearchDataSourceConfig.ReadOnly = new Wrapper(
    impl
  )
}
