package zio.aws.appsync.model
import scala.jdk.CollectionConverters.*
sealed trait FieldLogLevel {
  def unwrap: software.amazon.awssdk.services.appsync.model.FieldLogLevel
}
object FieldLogLevel {
  def wrap(
      value: software.amazon.awssdk.services.appsync.model.FieldLogLevel
  ): zio.aws.appsync.model.FieldLogLevel = value match {
    case software.amazon.awssdk.services.appsync.model.FieldLogLevel.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.appsync.model.FieldLogLevel.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.appsync.model.FieldLogLevel.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.appsync.model.FieldLogLevel.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion extends zio.aws.appsync.model.FieldLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.FieldLogLevel =
      software.amazon.awssdk.services.appsync.model.FieldLogLevel.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.appsync.model.FieldLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.FieldLogLevel =
      software.amazon.awssdk.services.appsync.model.FieldLogLevel.NONE
  }
  case object ERROR extends zio.aws.appsync.model.FieldLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.FieldLogLevel =
      software.amazon.awssdk.services.appsync.model.FieldLogLevel.ERROR
  }
  case object ALL extends zio.aws.appsync.model.FieldLogLevel {
    override def unwrap
        : software.amazon.awssdk.services.appsync.model.FieldLogLevel =
      software.amazon.awssdk.services.appsync.model.FieldLogLevel.ALL
  }
}
