package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class FlushApiCacheRequest(apiId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest = {
    import FlushApiCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.FlushApiCacheRequest.ReadOnly =
    zio.aws.appsync.model.FlushApiCacheRequest.wrap(buildAwsValue())
}
object FlushApiCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.FlushApiCacheRequest =
      zio.aws.appsync.model.FlushApiCacheRequest(apiId)
    def apiId: String
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest
  ) extends zio.aws.appsync.model.FlushApiCacheRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest
  ): zio.aws.appsync.model.FlushApiCacheRequest.ReadOnly = new Wrapper(impl)
}
