package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetApiCacheRequest(apiId: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.GetApiCacheRequest = {
    import GetApiCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.GetApiCacheRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.GetApiCacheRequest.ReadOnly =
    zio.aws.appsync.model.GetApiCacheRequest.wrap(buildAwsValue())
}
object GetApiCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.GetApiCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.GetApiCacheRequest =
      zio.aws.appsync.model.GetApiCacheRequest(apiId)
    def apiId: String
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.GetApiCacheRequest
  ) extends zio.aws.appsync.model.GetApiCacheRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.GetApiCacheRequest
  ): zio.aws.appsync.model.GetApiCacheRequest.ReadOnly = new Wrapper(impl)
}
