package zio.aws.appsync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.appsync.model.primitives.TTL
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class LambdaAuthorizerConfig(
    authorizerResultTtlInSeconds: Optional[TTL] = Optional.Absent,
    authorizerUri: String,
    identityValidationExpression: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig = {
    import LambdaAuthorizerConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig
      .builder()
      .optionallyWith(
        authorizerResultTtlInSeconds.map(value => TTL.unwrap(value): Integer)
      )(_.authorizerResultTtlInSeconds)
      .authorizerUri(authorizerUri: java.lang.String)
      .optionallyWith(
        identityValidationExpression.map(value => value: java.lang.String)
      )(_.identityValidationExpression)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly =
    zio.aws.appsync.model.LambdaAuthorizerConfig.wrap(buildAwsValue())
}
object LambdaAuthorizerConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.LambdaAuthorizerConfig =
      zio.aws.appsync.model.LambdaAuthorizerConfig(
        authorizerResultTtlInSeconds.map(value => value),
        authorizerUri,
        identityValidationExpression.map(value => value)
      )
    def authorizerResultTtlInSeconds: Optional[TTL]
    def authorizerUri: String
    def identityValidationExpression: Optional[String]
    def getAuthorizerResultTtlInSeconds: ZIO[Any, AwsError, TTL] =
      AwsError.unwrapOptionField(
        "authorizerResultTtlInSeconds",
        authorizerResultTtlInSeconds
      )
    def getAuthorizerUri: ZIO[Any, Nothing, String] = ZIO.succeed(authorizerUri)
    def getIdentityValidationExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "identityValidationExpression",
        identityValidationExpression
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig
  ) extends zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly {
    override val authorizerResultTtlInSeconds: Optional[TTL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authorizerResultTtlInSeconds())
        .map(value => zio.aws.appsync.model.primitives.TTL(value))
    override val authorizerUri: String = impl.authorizerUri(): String
    override val identityValidationExpression: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityValidationExpression())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.LambdaAuthorizerConfig
  ): zio.aws.appsync.model.LambdaAuthorizerConfig.ReadOnly = new Wrapper(impl)
}
