package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListGraphqlApisResponse(
    graphqlApis: Optional[Iterable[zio.aws.appsync.model.GraphqlApi]] =
      Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse = {
    import ListGraphqlApisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse
      .builder()
      .optionallyWith(
        graphqlApis.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.graphqlApis)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly =
    zio.aws.appsync.model.ListGraphqlApisResponse.wrap(buildAwsValue())
}
object ListGraphqlApisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.ListGraphqlApisResponse =
      zio.aws.appsync.model.ListGraphqlApisResponse(
        graphqlApis.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def graphqlApis: Optional[List[zio.aws.appsync.model.GraphqlApi.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getGraphqlApis
        : ZIO[Any, AwsError, List[zio.aws.appsync.model.GraphqlApi.ReadOnly]] =
      AwsError.unwrapOptionField("graphqlApis", graphqlApis)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse
  ) extends zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly {
    override val graphqlApis
        : Optional[List[zio.aws.appsync.model.GraphqlApi.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.graphqlApis())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appsync.model.GraphqlApi.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appsync.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse
  ): zio.aws.appsync.model.ListGraphqlApisResponse.ReadOnly = new Wrapper(impl)
}
