package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RelationalDatabaseDataSourceConfig(
    relationalDatabaseSourceType: Optional[
      zio.aws.appsync.model.RelationalDatabaseSourceType
    ] = Optional.Absent,
    rdsHttpEndpointConfig: Optional[
      zio.aws.appsync.model.RdsHttpEndpointConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.RelationalDatabaseDataSourceConfig = {
    import RelationalDatabaseDataSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.RelationalDatabaseDataSourceConfig
      .builder()
      .optionallyWith(relationalDatabaseSourceType.map(value => value.unwrap))(
        _.relationalDatabaseSourceType
      )
      .optionallyWith(
        rdsHttpEndpointConfig.map(value => value.buildAwsValue())
      )(_.rdsHttpEndpointConfig)
      .build()
  }
  def asReadOnly
      : zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly =
    zio.aws.appsync.model.RelationalDatabaseDataSourceConfig
      .wrap(buildAwsValue())
}
object RelationalDatabaseDataSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.RelationalDatabaseDataSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.RelationalDatabaseDataSourceConfig =
      zio.aws.appsync.model.RelationalDatabaseDataSourceConfig(
        relationalDatabaseSourceType.map(value => value),
        rdsHttpEndpointConfig.map(value => value.asEditable)
      )
    def relationalDatabaseSourceType
        : Optional[zio.aws.appsync.model.RelationalDatabaseSourceType]
    def rdsHttpEndpointConfig
        : Optional[zio.aws.appsync.model.RdsHttpEndpointConfig.ReadOnly]
    def getRelationalDatabaseSourceType: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.RelationalDatabaseSourceType
    ] = AwsError.unwrapOptionField(
      "relationalDatabaseSourceType",
      relationalDatabaseSourceType
    )
    def getRdsHttpEndpointConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appsync.model.RdsHttpEndpointConfig.ReadOnly
    ] =
      AwsError.unwrapOptionField("rdsHttpEndpointConfig", rdsHttpEndpointConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.RelationalDatabaseDataSourceConfig
  ) extends zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly {
    override val relationalDatabaseSourceType
        : Optional[zio.aws.appsync.model.RelationalDatabaseSourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relationalDatabaseSourceType())
        .map(value =>
          zio.aws.appsync.model.RelationalDatabaseSourceType.wrap(value)
        )
    override val rdsHttpEndpointConfig
        : Optional[zio.aws.appsync.model.RdsHttpEndpointConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rdsHttpEndpointConfig())
        .map(value => zio.aws.appsync.model.RdsHttpEndpointConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.RelationalDatabaseDataSourceConfig
  ): zio.aws.appsync.model.RelationalDatabaseDataSourceConfig.ReadOnly =
    new Wrapper(impl)
}
