package zio.aws.appsync.model
import zio.aws.appsync.model.primitives.{TagKey, ResourceArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: ResourceArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UntagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UntagResourceRequest.ReadOnly =
    zio.aws.appsync.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UntagResourceRequest =
      zio.aws.appsync.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ResourceArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UntagResourceRequest
  ) extends zio.aws.appsync.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.appsync.model.primitives.ResourceArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.appsync.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UntagResourceRequest
  ): zio.aws.appsync.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
