package zio.aws.appsync.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateApiCacheRequest(
    apiId: String,
    ttl: Long,
    apiCachingBehavior: zio.aws.appsync.model.ApiCachingBehavior,
    `type`: zio.aws.appsync.model.ApiCacheType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest = {
    import UpdateApiCacheRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest
      .builder()
      .apiId(apiId: java.lang.String)
      .ttl(ttl: java.lang.Long)
      .apiCachingBehavior(apiCachingBehavior.unwrap)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appsync.model.UpdateApiCacheRequest.ReadOnly =
    zio.aws.appsync.model.UpdateApiCacheRequest.wrap(buildAwsValue())
}
object UpdateApiCacheRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appsync.model.UpdateApiCacheRequest =
      zio.aws.appsync.model.UpdateApiCacheRequest(
        apiId,
        ttl,
        apiCachingBehavior,
        `type`
      )
    def apiId: String
    def ttl: Long
    def apiCachingBehavior: zio.aws.appsync.model.ApiCachingBehavior
    def `type`: zio.aws.appsync.model.ApiCacheType
    def getApiId: ZIO[Any, Nothing, String] = ZIO.succeed(apiId)
    def getTtl: ZIO[Any, Nothing, Long] = ZIO.succeed(ttl)
    def getApiCachingBehavior
        : ZIO[Any, Nothing, zio.aws.appsync.model.ApiCachingBehavior] =
      ZIO.succeed(apiCachingBehavior)
    def getType: ZIO[Any, Nothing, zio.aws.appsync.model.ApiCacheType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest
  ) extends zio.aws.appsync.model.UpdateApiCacheRequest.ReadOnly {
    override val apiId: String = impl.apiId(): String
    override val ttl: Long = impl.ttl(): Long
    override val apiCachingBehavior: zio.aws.appsync.model.ApiCachingBehavior =
      zio.aws.appsync.model.ApiCachingBehavior.wrap(impl.apiCachingBehavior())
    override val `type`: zio.aws.appsync.model.ApiCacheType =
      zio.aws.appsync.model.ApiCacheType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest
  ): zio.aws.appsync.model.UpdateApiCacheRequest.ReadOnly = new Wrapper(impl)
}
