package zio.aws.arczonalshift
import zio.aws.arczonalshift.model.ZonalShiftSummary.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.arczonalshift.paginators.{
  ListZonalShiftsPublisher,
  ListManagedResourcesPublisher
}
import software.amazon.awssdk.services.arczonalshift.{
  ArcZonalShiftAsyncClientBuilder,
  ArcZonalShiftAsyncClient
}
import zio.aws.arczonalshift.model.{
  CancelZonalShiftRequest,
  ListZonalShiftsRequest,
  ListManagedResourcesRequest,
  GetManagedResourceRequest,
  UpdateZonalShiftRequest,
  StartZonalShiftRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.arczonalshift.model.{
  ListZonalShiftsResponse,
  ZonalShiftSummary,
  ListManagedResourcesResponse,
  StartZonalShiftResponse,
  CancelZonalShiftResponse,
  ManagedResourceSummary,
  GetManagedResourceResponse,
  UpdateZonalShiftResponse
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait ArcZonalShift extends AspectSupport[ArcZonalShift] {
  val api: ArcZonalShiftAsyncClient
  def cancelZonalShift(
      request: CancelZonalShiftRequest
  ): IO[AwsError, zio.aws.arczonalshift.model.CancelZonalShiftResponse.ReadOnly]
  def listManagedResources(request: ListManagedResourcesRequest): ZStream[
    Any,
    AwsError,
    zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly
  ]
  def listManagedResourcesPaginated(request: ListManagedResourcesRequest): IO[
    AwsError,
    zio.aws.arczonalshift.model.ListManagedResourcesResponse.ReadOnly
  ]
  def listZonalShifts(
      request: ListZonalShiftsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listZonalShiftsPaginated(
      request: ListZonalShiftsRequest
  ): IO[AwsError, zio.aws.arczonalshift.model.ListZonalShiftsResponse.ReadOnly]
  def updateZonalShift(
      request: UpdateZonalShiftRequest
  ): IO[AwsError, zio.aws.arczonalshift.model.UpdateZonalShiftResponse.ReadOnly]
  def getManagedResource(request: GetManagedResourceRequest): IO[
    AwsError,
    zio.aws.arczonalshift.model.GetManagedResourceResponse.ReadOnly
  ]
  def startZonalShift(
      request: StartZonalShiftRequest
  ): IO[AwsError, zio.aws.arczonalshift.model.StartZonalShiftResponse.ReadOnly]
}
object ArcZonalShift {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ArcZonalShift] = customized(
    identity
  )
  def customized(
      customization: ArcZonalShiftAsyncClientBuilder => ArcZonalShiftAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ArcZonalShift] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ArcZonalShiftAsyncClientBuilder => ArcZonalShiftAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ArcZonalShift] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ArcZonalShiftAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ArcZonalShiftAsyncClient, ArcZonalShiftAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ArcZonalShiftAsyncClient,
      ArcZonalShiftAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ArcZonalShiftImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ArcZonalShiftImpl[R](
      override val api: ArcZonalShiftAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ArcZonalShift
      with AwsServiceBase[R] {
    override val serviceName: String = "ArcZonalShift"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ArcZonalShiftImpl[R1] = new ArcZonalShiftImpl(api, newAspect, r)
    def cancelZonalShift(request: CancelZonalShiftRequest): IO[
      AwsError,
      zio.aws.arczonalshift.model.CancelZonalShiftResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftRequest,
      CancelZonalShiftResponse
    ]("cancelZonalShift", api.cancelZonalShift)(request.buildAwsValue())
      .map(zio.aws.arczonalshift.model.CancelZonalShiftResponse.wrap)
      .provideEnvironment(r)
    def listManagedResources(request: ListManagedResourcesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest,
      ManagedResourceSummary,
      ListManagedResourcesPublisher
    ]("listManagedResources", api.listManagedResourcesPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.arczonalshift.model.ManagedResourceSummary.wrap(item))
      .provideEnvironment(r)
    def listManagedResourcesPaginated(request: ListManagedResourcesRequest): IO[
      AwsError,
      zio.aws.arczonalshift.model.ListManagedResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest,
      ListManagedResourcesResponse
    ]("listManagedResources", api.listManagedResources)(request.buildAwsValue())
      .map(zio.aws.arczonalshift.model.ListManagedResourcesResponse.wrap)
      .provideEnvironment(r)
    def listZonalShifts(
        request: ListZonalShiftsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest,
      ZonalShiftSummary,
      ListZonalShiftsPublisher
    ]("listZonalShifts", api.listZonalShiftsPaginator, _.items())(
      request.buildAwsValue()
    ).map(item => zio.aws.arczonalshift.model.ZonalShiftSummary.wrap(item))
      .provideEnvironment(r)
    def listZonalShiftsPaginated(request: ListZonalShiftsRequest): IO[
      AwsError,
      zio.aws.arczonalshift.model.ListZonalShiftsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest,
      ListZonalShiftsResponse
    ]("listZonalShifts", api.listZonalShifts)(request.buildAwsValue())
      .map(zio.aws.arczonalshift.model.ListZonalShiftsResponse.wrap)
      .provideEnvironment(r)
    def updateZonalShift(request: UpdateZonalShiftRequest): IO[
      AwsError,
      zio.aws.arczonalshift.model.UpdateZonalShiftResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftRequest,
      UpdateZonalShiftResponse
    ]("updateZonalShift", api.updateZonalShift)(request.buildAwsValue())
      .map(zio.aws.arczonalshift.model.UpdateZonalShiftResponse.wrap)
      .provideEnvironment(r)
    def getManagedResource(request: GetManagedResourceRequest): IO[
      AwsError,
      zio.aws.arczonalshift.model.GetManagedResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceRequest,
      GetManagedResourceResponse
    ]("getManagedResource", api.getManagedResource)(request.buildAwsValue())
      .map(zio.aws.arczonalshift.model.GetManagedResourceResponse.wrap)
      .provideEnvironment(r)
    def startZonalShift(request: StartZonalShiftRequest): IO[
      AwsError,
      zio.aws.arczonalshift.model.StartZonalShiftResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftRequest,
      StartZonalShiftResponse
    ]("startZonalShift", api.startZonalShift)(request.buildAwsValue())
      .map(zio.aws.arczonalshift.model.StartZonalShiftResponse.wrap)
      .provideEnvironment(r)
  }
  def cancelZonalShift(request: CancelZonalShiftRequest): ZIO[
    zio.aws.arczonalshift.ArcZonalShift,
    AwsError,
    zio.aws.arczonalshift.model.CancelZonalShiftResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelZonalShift(request))
  def listManagedResources(request: ListManagedResourcesRequest): ZStream[
    zio.aws.arczonalshift.ArcZonalShift,
    AwsError,
    zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listManagedResources(request))
  def listManagedResourcesPaginated(request: ListManagedResourcesRequest): ZIO[
    zio.aws.arczonalshift.ArcZonalShift,
    AwsError,
    zio.aws.arczonalshift.model.ListManagedResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listManagedResourcesPaginated(request))
  def listZonalShifts(
      request: ListZonalShiftsRequest
  ): ZStream[zio.aws.arczonalshift.ArcZonalShift, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listZonalShifts(request))
  def listZonalShiftsPaginated(request: ListZonalShiftsRequest): ZIO[
    zio.aws.arczonalshift.ArcZonalShift,
    AwsError,
    zio.aws.arczonalshift.model.ListZonalShiftsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listZonalShiftsPaginated(request))
  def updateZonalShift(request: UpdateZonalShiftRequest): ZIO[
    zio.aws.arczonalshift.ArcZonalShift,
    AwsError,
    zio.aws.arczonalshift.model.UpdateZonalShiftResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateZonalShift(request))
  def getManagedResource(request: GetManagedResourceRequest): ZIO[
    zio.aws.arczonalshift.ArcZonalShift,
    AwsError,
    zio.aws.arczonalshift.model.GetManagedResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getManagedResource(request))
  def startZonalShift(request: StartZonalShiftRequest): ZIO[
    zio.aws.arczonalshift.ArcZonalShift,
    AwsError,
    zio.aws.arczonalshift.model.StartZonalShiftResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startZonalShift(request))
}
