package zio.aws.arczonalshift
import zio.aws.arczonalshift.model.ZonalShiftSummary.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftAsyncClient
import zio.aws.arczonalshift.model.{
  CancelZonalShiftRequest,
  ListZonalShiftsRequest,
  ListManagedResourcesRequest,
  GetManagedResourceRequest,
  UpdateZonalShiftRequest,
  StartZonalShiftRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ArcZonalShiftMock extends Mock[ArcZonalShift] {
  object CancelZonalShift
      extends Effect[
        CancelZonalShiftRequest,
        AwsError,
        zio.aws.arczonalshift.model.CancelZonalShiftResponse.ReadOnly
      ]
  object ListManagedResources
      extends Stream[
        ListManagedResourcesRequest,
        AwsError,
        zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly
      ]
  object ListManagedResourcesPaginated
      extends Effect[
        ListManagedResourcesRequest,
        AwsError,
        zio.aws.arczonalshift.model.ListManagedResourcesResponse.ReadOnly
      ]
  object ListZonalShifts
      extends Stream[ListZonalShiftsRequest, AwsError, ReadOnly]
  object ListZonalShiftsPaginated
      extends Effect[
        ListZonalShiftsRequest,
        AwsError,
        zio.aws.arczonalshift.model.ListZonalShiftsResponse.ReadOnly
      ]
  object UpdateZonalShift
      extends Effect[
        UpdateZonalShiftRequest,
        AwsError,
        zio.aws.arczonalshift.model.UpdateZonalShiftResponse.ReadOnly
      ]
  object GetManagedResource
      extends Effect[
        GetManagedResourceRequest,
        AwsError,
        zio.aws.arczonalshift.model.GetManagedResourceResponse.ReadOnly
      ]
  object StartZonalShift
      extends Effect[
        StartZonalShiftRequest,
        AwsError,
        zio.aws.arczonalshift.model.StartZonalShiftResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ArcZonalShift] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, ArcZonalShift] { rts =>
        zio.ZIO.succeed {
          new ArcZonalShift {
            val api: ArcZonalShiftAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): ArcZonalShift = this
            def cancelZonalShift(request: CancelZonalShiftRequest): IO[
              AwsError,
              zio.aws.arczonalshift.model.CancelZonalShiftResponse.ReadOnly
            ] = proxy(CancelZonalShift, request)
            def listManagedResources(
                request: ListManagedResourcesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListManagedResources, request)
                }
                .getOrThrowFiberFailure()
            }
            def listManagedResourcesPaginated(
                request: ListManagedResourcesRequest
            ): IO[
              AwsError,
              zio.aws.arczonalshift.model.ListManagedResourcesResponse.ReadOnly
            ] = proxy(ListManagedResourcesPaginated, request)
            def listZonalShifts(
                request: ListZonalShiftsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListZonalShifts, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listZonalShiftsPaginated(request: ListZonalShiftsRequest): IO[
              AwsError,
              zio.aws.arczonalshift.model.ListZonalShiftsResponse.ReadOnly
            ] = proxy(ListZonalShiftsPaginated, request)
            def updateZonalShift(request: UpdateZonalShiftRequest): IO[
              AwsError,
              zio.aws.arczonalshift.model.UpdateZonalShiftResponse.ReadOnly
            ] = proxy(UpdateZonalShift, request)
            def getManagedResource(request: GetManagedResourceRequest): IO[
              AwsError,
              zio.aws.arczonalshift.model.GetManagedResourceResponse.ReadOnly
            ] = proxy(GetManagedResource, request)
            def startZonalShift(request: StartZonalShiftRequest): IO[
              AwsError,
              zio.aws.arczonalshift.model.StartZonalShiftResponse.ReadOnly
            ] = proxy(StartZonalShift, request)
          }
        }
      }
    }
  }
}
