package zio.aws.arczonalshift.model
import scala.jdk.CollectionConverters.*
sealed trait AppliedStatus {
  def unwrap: software.amazon.awssdk.services.arczonalshift.model.AppliedStatus
}
object AppliedStatus {
  def wrap(
      value: software.amazon.awssdk.services.arczonalshift.model.AppliedStatus
  ): zio.aws.arczonalshift.model.AppliedStatus = value match {
    case software.amazon.awssdk.services.arczonalshift.model.AppliedStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.arczonalshift.model.AppliedStatus.APPLIED =>
      val r = APPLIED
      r
    case software.amazon.awssdk.services.arczonalshift.model.AppliedStatus.NOT_APPLIED =>
      val r = NOT_APPLIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.arczonalshift.model.AppliedStatus {
    override def unwrap
        : software.amazon.awssdk.services.arczonalshift.model.AppliedStatus =
      software.amazon.awssdk.services.arczonalshift.model.AppliedStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object APPLIED extends zio.aws.arczonalshift.model.AppliedStatus {
    override def unwrap
        : software.amazon.awssdk.services.arczonalshift.model.AppliedStatus =
      software.amazon.awssdk.services.arczonalshift.model.AppliedStatus.APPLIED
  }
  case object NOT_APPLIED extends zio.aws.arczonalshift.model.AppliedStatus {
    override def unwrap
        : software.amazon.awssdk.services.arczonalshift.model.AppliedStatus =
      software.amazon.awssdk.services.arczonalshift.model.AppliedStatus.NOT_APPLIED
  }
}
