package zio.aws.arczonalshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.arczonalshift.model.primitives.{
  ExpiryTime,
  ZonalShiftComment,
  AvailabilityZone,
  ResourceIdentifier,
  StartTime,
  ZonalShiftId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CancelZonalShiftResponse(
    awayFrom: AvailabilityZone,
    comment: ZonalShiftComment,
    expiryTime: ExpiryTime,
    resourceIdentifier: ResourceIdentifier,
    startTime: StartTime,
    status: zio.aws.arczonalshift.model.ZonalShiftStatus,
    zonalShiftId: ZonalShiftId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftResponse = {
    import CancelZonalShiftResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftResponse
      .builder()
      .awayFrom(AvailabilityZone.unwrap(awayFrom): java.lang.String)
      .comment(ZonalShiftComment.unwrap(comment): java.lang.String)
      .expiryTime(ExpiryTime.unwrap(expiryTime): Instant)
      .resourceIdentifier(
        ResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .startTime(StartTime.unwrap(startTime): Instant)
      .status(status.unwrap)
      .zonalShiftId(ZonalShiftId.unwrap(zonalShiftId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.arczonalshift.model.CancelZonalShiftResponse.ReadOnly =
    zio.aws.arczonalshift.model.CancelZonalShiftResponse.wrap(buildAwsValue())
}
object CancelZonalShiftResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.CancelZonalShiftResponse =
      zio.aws.arczonalshift.model.CancelZonalShiftResponse(
        awayFrom,
        comment,
        expiryTime,
        resourceIdentifier,
        startTime,
        status,
        zonalShiftId
      )
    def awayFrom: AvailabilityZone
    def comment: ZonalShiftComment
    def expiryTime: ExpiryTime
    def resourceIdentifier: ResourceIdentifier
    def startTime: StartTime
    def status: zio.aws.arczonalshift.model.ZonalShiftStatus
    def zonalShiftId: ZonalShiftId
    def getAwayFrom: ZIO[Any, Nothing, AvailabilityZone] = ZIO.succeed(awayFrom)
    def getComment: ZIO[Any, Nothing, ZonalShiftComment] = ZIO.succeed(comment)
    def getExpiryTime: ZIO[Any, Nothing, ExpiryTime] = ZIO.succeed(expiryTime)
    def getResourceIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
    def getStartTime: ZIO[Any, Nothing, StartTime] = ZIO.succeed(startTime)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.arczonalshift.model.ZonalShiftStatus] =
      ZIO.succeed(status)
    def getZonalShiftId: ZIO[Any, Nothing, ZonalShiftId] =
      ZIO.succeed(zonalShiftId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftResponse
  ) extends zio.aws.arczonalshift.model.CancelZonalShiftResponse.ReadOnly {
    override val awayFrom: AvailabilityZone =
      zio.aws.arczonalshift.model.primitives.AvailabilityZone(impl.awayFrom())
    override val comment: ZonalShiftComment =
      zio.aws.arczonalshift.model.primitives.ZonalShiftComment(impl.comment())
    override val expiryTime: ExpiryTime =
      zio.aws.arczonalshift.model.primitives.ExpiryTime(impl.expiryTime())
    override val resourceIdentifier: ResourceIdentifier =
      zio.aws.arczonalshift.model.primitives
        .ResourceIdentifier(impl.resourceIdentifier())
    override val startTime: StartTime =
      zio.aws.arczonalshift.model.primitives.StartTime(impl.startTime())
    override val status: zio.aws.arczonalshift.model.ZonalShiftStatus =
      zio.aws.arczonalshift.model.ZonalShiftStatus.wrap(impl.status())
    override val zonalShiftId: ZonalShiftId =
      zio.aws.arczonalshift.model.primitives.ZonalShiftId(impl.zonalShiftId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.CancelZonalShiftResponse
  ): zio.aws.arczonalshift.model.CancelZonalShiftResponse.ReadOnly =
    new Wrapper(impl)
}
