package zio.aws.arczonalshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.arczonalshift.model.primitives.ResourceIdentifier
import scala.jdk.CollectionConverters.*
final case class GetManagedResourceRequest(
    resourceIdentifier: ResourceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceRequest = {
    import GetManagedResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceRequest
      .builder()
      .resourceIdentifier(
        ResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.arczonalshift.model.GetManagedResourceRequest.ReadOnly =
    zio.aws.arczonalshift.model.GetManagedResourceRequest.wrap(buildAwsValue())
}
object GetManagedResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.GetManagedResourceRequest =
      zio.aws.arczonalshift.model.GetManagedResourceRequest(resourceIdentifier)
    def resourceIdentifier: ResourceIdentifier
    def getResourceIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceRequest
  ) extends zio.aws.arczonalshift.model.GetManagedResourceRequest.ReadOnly {
    override val resourceIdentifier: ResourceIdentifier =
      zio.aws.arczonalshift.model.primitives
        .ResourceIdentifier(impl.resourceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceRequest
  ): zio.aws.arczonalshift.model.GetManagedResourceRequest.ReadOnly =
    new Wrapper(impl)
}
