package zio.aws.arczonalshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.arczonalshift.model.primitives.{
  ResourceName,
  ResourceArn,
  Weight,
  AvailabilityZone
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetManagedResourceResponse(
    appliedWeights: Map[AvailabilityZone, Weight],
    arn: Optional[ResourceArn] = Optional.Absent,
    name: Optional[ResourceName] = Optional.Absent,
    zonalShifts: Iterable[zio.aws.arczonalshift.model.ZonalShiftInResource]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceResponse = {
    import GetManagedResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceResponse
      .builder()
      .appliedWeights(
        appliedWeights
          .map({ case (key, value) =>
            (AvailabilityZone.unwrap(key): java.lang.String) -> (Weight.unwrap(
              value
            ): java.lang.Float)
          })
          .asJava
      )
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .zonalShifts(zonalShifts.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.arczonalshift.model.GetManagedResourceResponse.ReadOnly =
    zio.aws.arczonalshift.model.GetManagedResourceResponse.wrap(buildAwsValue())
}
object GetManagedResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.GetManagedResourceResponse =
      zio.aws.arczonalshift.model.GetManagedResourceResponse(
        appliedWeights,
        arn.map(value => value),
        name.map(value => value),
        zonalShifts.map { item =>
          item.asEditable
        }
      )
    def appliedWeights: Map[AvailabilityZone, Weight]
    def arn: Optional[ResourceArn]
    def name: Optional[ResourceName]
    def zonalShifts
        : List[zio.aws.arczonalshift.model.ZonalShiftInResource.ReadOnly]
    def getAppliedWeights: ZIO[Any, Nothing, Map[AvailabilityZone, Weight]] =
      ZIO.succeed(appliedWeights)
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getZonalShifts: ZIO[Any, Nothing, List[
      zio.aws.arczonalshift.model.ZonalShiftInResource.ReadOnly
    ]] = ZIO.succeed(zonalShifts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceResponse
  ) extends zio.aws.arczonalshift.model.GetManagedResourceResponse.ReadOnly {
    override val appliedWeights: Map[AvailabilityZone, Weight] = impl
      .appliedWeights()
      .asScala
      .map({ case (key, value) =>
        zio.aws.arczonalshift.model.primitives.AvailabilityZone(
          key
        ) -> zio.aws.arczonalshift.model.primitives.Weight(value)
      })
      .toMap
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.arczonalshift.model.primitives.ResourceArn(value))
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.arczonalshift.model.primitives.ResourceName(value))
    override val zonalShifts
        : List[zio.aws.arczonalshift.model.ZonalShiftInResource.ReadOnly] = impl
      .zonalShifts()
      .asScala
      .map { item =>
        zio.aws.arczonalshift.model.ZonalShiftInResource.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.GetManagedResourceResponse
  ): zio.aws.arczonalshift.model.GetManagedResourceResponse.ReadOnly =
    new Wrapper(impl)
}
