package zio.aws.arczonalshift.model
import zio.prelude.data.Optional
import zio.aws.arczonalshift.model.primitives.MaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListManagedResourcesRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest = {
    import ListManagedResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.arczonalshift.model.ListManagedResourcesRequest.ReadOnly =
    zio.aws.arczonalshift.model.ListManagedResourcesRequest
      .wrap(buildAwsValue())
}
object ListManagedResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.ListManagedResourcesRequest =
      zio.aws.arczonalshift.model.ListManagedResourcesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest
  ) extends zio.aws.arczonalshift.model.ListManagedResourcesRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.arczonalshift.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest
  ): zio.aws.arczonalshift.model.ListManagedResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
