package zio.aws.arczonalshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListManagedResourcesResponse(
    items: Iterable[zio.aws.arczonalshift.model.ManagedResourceSummary],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse = {
    import ListManagedResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse
      .builder()
      .items(items.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.arczonalshift.model.ListManagedResourcesResponse.ReadOnly =
    zio.aws.arczonalshift.model.ListManagedResourcesResponse
      .wrap(buildAwsValue())
}
object ListManagedResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.ListManagedResourcesResponse =
      zio.aws.arczonalshift.model.ListManagedResourcesResponse(
        items.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def items: List[zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly]
    def nextToken: Optional[String]
    def getItems: ZIO[Any, Nothing, List[
      zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly
    ]] = ZIO.succeed(items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse
  ) extends zio.aws.arczonalshift.model.ListManagedResourcesResponse.ReadOnly {
    override val items
        : List[zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly] =
      impl
        .items()
        .asScala
        .map { item =>
          zio.aws.arczonalshift.model.ManagedResourceSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse
  ): zio.aws.arczonalshift.model.ListManagedResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
