package zio.aws.arczonalshift.model
import zio.prelude.data.Optional
import zio.aws.arczonalshift.model.primitives.MaxResults
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListZonalShiftsRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.arczonalshift.model.ZonalShiftStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest = {
    import ListZonalShiftsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.arczonalshift.model.ListZonalShiftsRequest.ReadOnly =
    zio.aws.arczonalshift.model.ListZonalShiftsRequest.wrap(buildAwsValue())
}
object ListZonalShiftsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.ListZonalShiftsRequest =
      zio.aws.arczonalshift.model.ListZonalShiftsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        status.map(value => value)
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[String]
    def status: Optional[zio.aws.arczonalshift.model.ZonalShiftStatus]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.arczonalshift.model.ZonalShiftStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest
  ) extends zio.aws.arczonalshift.model.ListZonalShiftsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.arczonalshift.model.primitives.MaxResults(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.arczonalshift.model.ZonalShiftStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.arczonalshift.model.ZonalShiftStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsRequest
  ): zio.aws.arczonalshift.model.ListZonalShiftsRequest.ReadOnly = new Wrapper(
    impl
  )
}
