package zio.aws.arczonalshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListZonalShiftsResponse(
    items: Optional[Iterable[zio.aws.arczonalshift.model.ZonalShiftSummary]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse = {
    import ListZonalShiftsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.arczonalshift.model.ListZonalShiftsResponse.ReadOnly =
    zio.aws.arczonalshift.model.ListZonalShiftsResponse.wrap(buildAwsValue())
}
object ListZonalShiftsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.ListZonalShiftsResponse =
      zio.aws.arczonalshift.model.ListZonalShiftsResponse(
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def items
        : Optional[List[zio.aws.arczonalshift.model.ZonalShiftSummary.ReadOnly]]
    def nextToken: Optional[String]
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.arczonalshift.model.ZonalShiftSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse
  ) extends zio.aws.arczonalshift.model.ListZonalShiftsResponse.ReadOnly {
    override val items: Optional[
      List[zio.aws.arczonalshift.model.ZonalShiftSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.arczonalshift.model.ZonalShiftSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.ListZonalShiftsResponse
  ): zio.aws.arczonalshift.model.ListZonalShiftsResponse.ReadOnly = new Wrapper(
    impl
  )
}
