package zio.aws.arczonalshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.arczonalshift.model.primitives.{
  ResourceName,
  AvailabilityZone,
  ResourceArn
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ManagedResourceSummary(
    arn: Optional[ResourceArn] = Optional.Absent,
    availabilityZones: Iterable[AvailabilityZone],
    name: Optional[ResourceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.ManagedResourceSummary = {
    import ManagedResourceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.ManagedResourceSummary
      .builder()
      .optionallyWith(
        arn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .availabilityZones(availabilityZones.map { item =>
        AvailabilityZone.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly =
    zio.aws.arczonalshift.model.ManagedResourceSummary.wrap(buildAwsValue())
}
object ManagedResourceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.ManagedResourceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.ManagedResourceSummary =
      zio.aws.arczonalshift.model.ManagedResourceSummary(
        arn.map(value => value),
        availabilityZones,
        name.map(value => value)
      )
    def arn: Optional[ResourceArn]
    def availabilityZones: List[AvailabilityZone]
    def name: Optional[ResourceName]
    def getArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getAvailabilityZones: ZIO[Any, Nothing, List[AvailabilityZone]] =
      ZIO.succeed(availabilityZones)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.ManagedResourceSummary
  ) extends zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly {
    override val arn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.arczonalshift.model.primitives.ResourceArn(value))
    override val availabilityZones: List[AvailabilityZone] = impl
      .availabilityZones()
      .asScala
      .map { item =>
        zio.aws.arczonalshift.model.primitives.AvailabilityZone(item)
      }
      .toList
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.arczonalshift.model.primitives.ResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.ManagedResourceSummary
  ): zio.aws.arczonalshift.model.ManagedResourceSummary.ReadOnly = new Wrapper(
    impl
  )
}
