package zio.aws.arczonalshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.arczonalshift.model.primitives.{
  ResourceIdentifier,
  ExpiresIn,
  ZonalShiftComment,
  AvailabilityZone
}
import scala.jdk.CollectionConverters.*
final case class StartZonalShiftRequest(
    awayFrom: AvailabilityZone,
    comment: ZonalShiftComment,
    expiresIn: ExpiresIn,
    resourceIdentifier: ResourceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftRequest = {
    import StartZonalShiftRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftRequest
      .builder()
      .awayFrom(AvailabilityZone.unwrap(awayFrom): java.lang.String)
      .comment(ZonalShiftComment.unwrap(comment): java.lang.String)
      .expiresIn(ExpiresIn.unwrap(expiresIn): java.lang.String)
      .resourceIdentifier(
        ResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.arczonalshift.model.StartZonalShiftRequest.ReadOnly =
    zio.aws.arczonalshift.model.StartZonalShiftRequest.wrap(buildAwsValue())
}
object StartZonalShiftRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.StartZonalShiftRequest =
      zio.aws.arczonalshift.model.StartZonalShiftRequest(
        awayFrom,
        comment,
        expiresIn,
        resourceIdentifier
      )
    def awayFrom: AvailabilityZone
    def comment: ZonalShiftComment
    def expiresIn: ExpiresIn
    def resourceIdentifier: ResourceIdentifier
    def getAwayFrom: ZIO[Any, Nothing, AvailabilityZone] = ZIO.succeed(awayFrom)
    def getComment: ZIO[Any, Nothing, ZonalShiftComment] = ZIO.succeed(comment)
    def getExpiresIn: ZIO[Any, Nothing, ExpiresIn] = ZIO.succeed(expiresIn)
    def getResourceIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftRequest
  ) extends zio.aws.arczonalshift.model.StartZonalShiftRequest.ReadOnly {
    override val awayFrom: AvailabilityZone =
      zio.aws.arczonalshift.model.primitives.AvailabilityZone(impl.awayFrom())
    override val comment: ZonalShiftComment =
      zio.aws.arczonalshift.model.primitives.ZonalShiftComment(impl.comment())
    override val expiresIn: ExpiresIn =
      zio.aws.arczonalshift.model.primitives.ExpiresIn(impl.expiresIn())
    override val resourceIdentifier: ResourceIdentifier =
      zio.aws.arczonalshift.model.primitives
        .ResourceIdentifier(impl.resourceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.StartZonalShiftRequest
  ): zio.aws.arczonalshift.model.StartZonalShiftRequest.ReadOnly = new Wrapper(
    impl
  )
}
