package zio.aws.arczonalshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.arczonalshift.model.primitives.{
  ZonalShiftId,
  ExpiresIn,
  ZonalShiftComment
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateZonalShiftRequest(
    comment: Optional[ZonalShiftComment] = Optional.Absent,
    expiresIn: Optional[ExpiresIn] = Optional.Absent,
    zonalShiftId: ZonalShiftId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftRequest = {
    import UpdateZonalShiftRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftRequest
      .builder()
      .optionallyWith(
        comment.map(value => ZonalShiftComment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        expiresIn.map(value => ExpiresIn.unwrap(value): java.lang.String)
      )(_.expiresIn)
      .zonalShiftId(ZonalShiftId.unwrap(zonalShiftId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.arczonalshift.model.UpdateZonalShiftRequest.ReadOnly =
    zio.aws.arczonalshift.model.UpdateZonalShiftRequest.wrap(buildAwsValue())
}
object UpdateZonalShiftRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.UpdateZonalShiftRequest =
      zio.aws.arczonalshift.model.UpdateZonalShiftRequest(
        comment.map(value => value),
        expiresIn.map(value => value),
        zonalShiftId
      )
    def comment: Optional[ZonalShiftComment]
    def expiresIn: Optional[ExpiresIn]
    def zonalShiftId: ZonalShiftId
    def getComment: ZIO[Any, AwsError, ZonalShiftComment] =
      AwsError.unwrapOptionField("comment", comment)
    def getExpiresIn: ZIO[Any, AwsError, ExpiresIn] =
      AwsError.unwrapOptionField("expiresIn", expiresIn)
    def getZonalShiftId: ZIO[Any, Nothing, ZonalShiftId] =
      ZIO.succeed(zonalShiftId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftRequest
  ) extends zio.aws.arczonalshift.model.UpdateZonalShiftRequest.ReadOnly {
    override val comment: Optional[ZonalShiftComment] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value =>
        zio.aws.arczonalshift.model.primitives.ZonalShiftComment(value)
      )
    override val expiresIn: Optional[ExpiresIn] = zio.aws.core.internal
      .optionalFromNullable(impl.expiresIn())
      .map(value => zio.aws.arczonalshift.model.primitives.ExpiresIn(value))
    override val zonalShiftId: ZonalShiftId =
      zio.aws.arczonalshift.model.primitives.ZonalShiftId(impl.zonalShiftId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.UpdateZonalShiftRequest
  ): zio.aws.arczonalshift.model.UpdateZonalShiftRequest.ReadOnly = new Wrapper(
    impl
  )
}
