package zio.aws.arczonalshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.arczonalshift.model.primitives.{
  ExpiryTime,
  ZonalShiftComment,
  AvailabilityZone,
  ResourceIdentifier,
  StartTime,
  ZonalShiftId
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ZonalShiftInResource(
    appliedStatus: zio.aws.arczonalshift.model.AppliedStatus,
    awayFrom: AvailabilityZone,
    comment: ZonalShiftComment,
    expiryTime: ExpiryTime,
    resourceIdentifier: ResourceIdentifier,
    startTime: StartTime,
    zonalShiftId: ZonalShiftId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource = {
    import ZonalShiftInResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource
      .builder()
      .appliedStatus(appliedStatus.unwrap)
      .awayFrom(AvailabilityZone.unwrap(awayFrom): java.lang.String)
      .comment(ZonalShiftComment.unwrap(comment): java.lang.String)
      .expiryTime(ExpiryTime.unwrap(expiryTime): Instant)
      .resourceIdentifier(
        ResourceIdentifier.unwrap(resourceIdentifier): java.lang.String
      )
      .startTime(StartTime.unwrap(startTime): Instant)
      .zonalShiftId(ZonalShiftId.unwrap(zonalShiftId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.arczonalshift.model.ZonalShiftInResource.ReadOnly =
    zio.aws.arczonalshift.model.ZonalShiftInResource.wrap(buildAwsValue())
}
object ZonalShiftInResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.arczonalshift.model.ZonalShiftInResource =
      zio.aws.arczonalshift.model.ZonalShiftInResource(
        appliedStatus,
        awayFrom,
        comment,
        expiryTime,
        resourceIdentifier,
        startTime,
        zonalShiftId
      )
    def appliedStatus: zio.aws.arczonalshift.model.AppliedStatus
    def awayFrom: AvailabilityZone
    def comment: ZonalShiftComment
    def expiryTime: ExpiryTime
    def resourceIdentifier: ResourceIdentifier
    def startTime: StartTime
    def zonalShiftId: ZonalShiftId
    def getAppliedStatus
        : ZIO[Any, Nothing, zio.aws.arczonalshift.model.AppliedStatus] =
      ZIO.succeed(appliedStatus)
    def getAwayFrom: ZIO[Any, Nothing, AvailabilityZone] = ZIO.succeed(awayFrom)
    def getComment: ZIO[Any, Nothing, ZonalShiftComment] = ZIO.succeed(comment)
    def getExpiryTime: ZIO[Any, Nothing, ExpiryTime] = ZIO.succeed(expiryTime)
    def getResourceIdentifier: ZIO[Any, Nothing, ResourceIdentifier] =
      ZIO.succeed(resourceIdentifier)
    def getStartTime: ZIO[Any, Nothing, StartTime] = ZIO.succeed(startTime)
    def getZonalShiftId: ZIO[Any, Nothing, ZonalShiftId] =
      ZIO.succeed(zonalShiftId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource
  ) extends zio.aws.arczonalshift.model.ZonalShiftInResource.ReadOnly {
    override val appliedStatus: zio.aws.arczonalshift.model.AppliedStatus =
      zio.aws.arczonalshift.model.AppliedStatus.wrap(impl.appliedStatus())
    override val awayFrom: AvailabilityZone =
      zio.aws.arczonalshift.model.primitives.AvailabilityZone(impl.awayFrom())
    override val comment: ZonalShiftComment =
      zio.aws.arczonalshift.model.primitives.ZonalShiftComment(impl.comment())
    override val expiryTime: ExpiryTime =
      zio.aws.arczonalshift.model.primitives.ExpiryTime(impl.expiryTime())
    override val resourceIdentifier: ResourceIdentifier =
      zio.aws.arczonalshift.model.primitives
        .ResourceIdentifier(impl.resourceIdentifier())
    override val startTime: StartTime =
      zio.aws.arczonalshift.model.primitives.StartTime(impl.startTime())
    override val zonalShiftId: ZonalShiftId =
      zio.aws.arczonalshift.model.primitives.ZonalShiftId(impl.zonalShiftId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.arczonalshift.model.ZonalShiftInResource
  ): zio.aws.arczonalshift.model.ZonalShiftInResource.ReadOnly = new Wrapper(
    impl
  )
}
