package zio.aws.arczonalshift.model
import scala.jdk.CollectionConverters.*
sealed trait ZonalShiftStatus {
  def unwrap
      : software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus
}
object ZonalShiftStatus {
  def wrap(
      value: software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus
  ): zio.aws.arczonalshift.model.ZonalShiftStatus = value match {
    case software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus.EXPIRED =>
      val r = EXPIRED
      r
    case software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus.CANCELED =>
      val r = CANCELED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.arczonalshift.model.ZonalShiftStatus {
    override def unwrap
        : software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus =
      software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.arczonalshift.model.ZonalShiftStatus {
    override def unwrap
        : software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus =
      software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus.ACTIVE
  }
  case object EXPIRED extends zio.aws.arczonalshift.model.ZonalShiftStatus {
    override def unwrap
        : software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus =
      software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus.EXPIRED
  }
  case object CANCELED extends zio.aws.arczonalshift.model.ZonalShiftStatus {
    override def unwrap
        : software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus =
      software.amazon.awssdk.services.arczonalshift.model.ZonalShiftStatus.CANCELED
  }
}
