package zio.aws.arczonalshift
import zio.prelude.Subtype
import zio.aws.arczonalshift.model.primitives.{Weight, AvailabilityZone}
import java.time.Instant
import zio.aws.arczonalshift.model.primitives.ResourceIdentifier.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AvailabilityZone extends Subtype[String]
    type AvailabilityZone =
      zio.aws.arczonalshift.model.primitives.AvailabilityZone.Type
    object ExpiresIn extends Subtype[String]
    type ExpiresIn = zio.aws.arczonalshift.model.primitives.ExpiresIn.Type
    object ExpiryTime extends Subtype[Instant]
    type ExpiryTime = zio.aws.arczonalshift.model.primitives.ExpiryTime.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.arczonalshift.model.primitives.MaxResults.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.arczonalshift.model.primitives.ResourceArn.Type
    object ResourceIdentifier extends Subtype[String]
    type ResourceIdentifier =
      zio.aws.arczonalshift.model.primitives.ResourceIdentifier.Type
    object ResourceName extends Subtype[String]
    type ResourceName = zio.aws.arczonalshift.model.primitives.ResourceName.Type
    object StartTime extends Subtype[Instant]
    type StartTime = zio.aws.arczonalshift.model.primitives.StartTime.Type
    object Weight extends Subtype[Float]
    type Weight = zio.aws.arczonalshift.model.primitives.Weight.Type
    object ZonalShiftComment extends Subtype[String]
    type ZonalShiftComment =
      zio.aws.arczonalshift.model.primitives.ZonalShiftComment.Type
    object ZonalShiftId extends Subtype[String]
    type ZonalShiftId = zio.aws.arczonalshift.model.primitives.ZonalShiftId.Type
  }
  type AppliedWeights = Map[AvailabilityZone, Weight]
  type AvailabilityZones = List[AvailabilityZone]
  type ManagedResourceSummaries =
    List[zio.aws.arczonalshift.model.ManagedResourceSummary]
  type ZonalShiftSummaries = List[zio.aws.arczonalshift.model.ZonalShiftSummary]
  type ZonalShiftsInResource =
    List[zio.aws.arczonalshift.model.ZonalShiftInResource]
}
