package zio.aws.athena.model
import zio.aws.athena.model.primitives.QueryExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class BatchGetQueryExecutionRequest(
    queryExecutionIds: Iterable[QueryExecutionId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest = {
    import BatchGetQueryExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest
      .builder()
      .queryExecutionIds(queryExecutionIds.map { item =>
        QueryExecutionId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.BatchGetQueryExecutionRequest.ReadOnly =
    zio.aws.athena.model.BatchGetQueryExecutionRequest.wrap(buildAwsValue())
}
object BatchGetQueryExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.BatchGetQueryExecutionRequest =
      zio.aws.athena.model.BatchGetQueryExecutionRequest(queryExecutionIds)
    def queryExecutionIds: List[QueryExecutionId]
    def getQueryExecutionIds: ZIO[Any, Nothing, List[QueryExecutionId]] =
      ZIO.succeed(queryExecutionIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest
  ) extends zio.aws.athena.model.BatchGetQueryExecutionRequest.ReadOnly {
    override val queryExecutionIds: List[QueryExecutionId] = impl
      .queryExecutionIds()
      .asScala
      .map { item =>
        zio.aws.athena.model.primitives.QueryExecutionId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.BatchGetQueryExecutionRequest
  ): zio.aws.athena.model.BatchGetQueryExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
