package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait ColumnNullable {
  def unwrap: software.amazon.awssdk.services.athena.model.ColumnNullable
}
object ColumnNullable {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.ColumnNullable
  ): zio.aws.athena.model.ColumnNullable = value match {
    case software.amazon.awssdk.services.athena.model.ColumnNullable.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.ColumnNullable.NOT_NULL =>
      val r = NOT_NULL
      r
    case software.amazon.awssdk.services.athena.model.ColumnNullable.NULLABLE =>
      val r = NULLABLE
      r
    case software.amazon.awssdk.services.athena.model.ColumnNullable.UNKNOWN =>
      val r = UNKNOWN
      r
  }
  case object unknownToSdkVersion extends zio.aws.athena.model.ColumnNullable {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ColumnNullable =
      software.amazon.awssdk.services.athena.model.ColumnNullable.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_NULL extends zio.aws.athena.model.ColumnNullable {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ColumnNullable =
      software.amazon.awssdk.services.athena.model.ColumnNullable.NOT_NULL
  }
  case object NULLABLE extends zio.aws.athena.model.ColumnNullable {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ColumnNullable =
      software.amazon.awssdk.services.athena.model.ColumnNullable.NULLABLE
  }
  case object UNKNOWN extends zio.aws.athena.model.ColumnNullable {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.ColumnNullable =
      software.amazon.awssdk.services.athena.model.ColumnNullable.UNKNOWN
  }
}
