package zio.aws.athena.model
import zio.aws.athena.model.primitives.NamedQueryId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateNamedQueryResponse(
    namedQueryId: Option[NamedQueryId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse = {
    import CreateNamedQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse
      .builder()
      .optionallyWith(
        namedQueryId.map(value => NamedQueryId.unwrap(value): java.lang.String)
      )(_.namedQueryId)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly =
    zio.aws.athena.model.CreateNamedQueryResponse.wrap(buildAwsValue())
}
object CreateNamedQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.CreateNamedQueryResponse =
      zio.aws.athena.model
        .CreateNamedQueryResponse(namedQueryId.map(value => value))
    def namedQueryId: Option[NamedQueryId]
    def getNamedQueryId: ZIO[Any, AwsError, NamedQueryId] =
      AwsError.unwrapOptionField("namedQueryId", namedQueryId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse
  ) extends zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly {
    override val namedQueryId: Option[NamedQueryId] = scala
      .Option(impl.namedQueryId())
      .map(value => zio.aws.athena.model.primitives.NamedQueryId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.CreateNamedQueryResponse
  ): zio.aws.athena.model.CreateNamedQueryResponse.ReadOnly = new Wrapper(impl)
}
