package zio.aws.athena.model
import zio.aws.athena.model.primitives.CatalogNameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DataCatalogSummary(
    catalogName: Option[CatalogNameString] = None,
    `type`: Option[zio.aws.athena.model.DataCatalogType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.DataCatalogSummary = {
    import DataCatalogSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.DataCatalogSummary
      .builder()
      .optionallyWith(
        catalogName.map(value =>
          CatalogNameString.unwrap(value): java.lang.String
        )
      )(_.catalogName)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.DataCatalogSummary.ReadOnly =
    zio.aws.athena.model.DataCatalogSummary.wrap(buildAwsValue())
}
object DataCatalogSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.DataCatalogSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.DataCatalogSummary =
      zio.aws.athena.model.DataCatalogSummary(
        catalogName.map(value => value),
        `type`.map(value => value)
      )
    def catalogName: Option[CatalogNameString]
    def `type`: Option[zio.aws.athena.model.DataCatalogType]
    def getCatalogName: ZIO[Any, AwsError, CatalogNameString] =
      AwsError.unwrapOptionField("catalogName", catalogName)
    def getType: ZIO[Any, AwsError, zio.aws.athena.model.DataCatalogType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.DataCatalogSummary
  ) extends zio.aws.athena.model.DataCatalogSummary.ReadOnly {
    override val catalogName: Option[CatalogNameString] = scala
      .Option(impl.catalogName())
      .map(value => zio.aws.athena.model.primitives.CatalogNameString(value))
    override val `type`: Option[zio.aws.athena.model.DataCatalogType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.athena.model.DataCatalogType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.DataCatalogSummary
  ): zio.aws.athena.model.DataCatalogSummary.ReadOnly = new Wrapper(impl)
}
