package zio.aws.athena.model
import scala.jdk.CollectionConverters.*
sealed trait EncryptionOption {
  def unwrap: software.amazon.awssdk.services.athena.model.EncryptionOption
}
object EncryptionOption {
  def wrap(
      value: software.amazon.awssdk.services.athena.model.EncryptionOption
  ): zio.aws.athena.model.EncryptionOption = value match {
    case software.amazon.awssdk.services.athena.model.EncryptionOption.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.athena.model.EncryptionOption.SSE_S3 =>
      val r = SSE_S3
      r
    case software.amazon.awssdk.services.athena.model.EncryptionOption.SSE_KMS =>
      val r = SSE_KMS
      r
    case software.amazon.awssdk.services.athena.model.EncryptionOption.CSE_KMS =>
      val r = CSE_KMS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.athena.model.EncryptionOption {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.EncryptionOption =
      software.amazon.awssdk.services.athena.model.EncryptionOption.UNKNOWN_TO_SDK_VERSION
  }
  case object SSE_S3 extends zio.aws.athena.model.EncryptionOption {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.EncryptionOption =
      software.amazon.awssdk.services.athena.model.EncryptionOption.SSE_S3
  }
  case object SSE_KMS extends zio.aws.athena.model.EncryptionOption {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.EncryptionOption =
      software.amazon.awssdk.services.athena.model.EncryptionOption.SSE_KMS
  }
  case object CSE_KMS extends zio.aws.athena.model.EncryptionOption {
    override def unwrap
        : software.amazon.awssdk.services.athena.model.EncryptionOption =
      software.amazon.awssdk.services.athena.model.EncryptionOption.CSE_KMS
  }
}
