package zio.aws.athena.model
import zio.aws.athena.model.primitives.{NameString, CatalogNameString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDatabaseRequest(
    catalogName: CatalogNameString,
    databaseName: NameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetDatabaseRequest = {
    import GetDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetDatabaseRequest
      .builder()
      .catalogName(CatalogNameString.unwrap(catalogName): java.lang.String)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetDatabaseRequest.ReadOnly =
    zio.aws.athena.model.GetDatabaseRequest.wrap(buildAwsValue())
}
object GetDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetDatabaseRequest =
      zio.aws.athena.model.GetDatabaseRequest(catalogName, databaseName)
    def catalogName: CatalogNameString
    def databaseName: NameString
    def getCatalogName: ZIO[Any, Nothing, CatalogNameString] =
      ZIO.succeed(catalogName)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetDatabaseRequest
  ) extends zio.aws.athena.model.GetDatabaseRequest.ReadOnly {
    override val catalogName: CatalogNameString =
      zio.aws.athena.model.primitives.CatalogNameString(impl.catalogName())
    override val databaseName: NameString =
      zio.aws.athena.model.primitives.NameString(impl.databaseName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetDatabaseRequest
  ): zio.aws.athena.model.GetDatabaseRequest.ReadOnly = new Wrapper(impl)
}
