package zio.aws.athena.model
import zio.aws.athena.model.primitives.{WorkGroupName, StatementName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetPreparedStatementRequest(
    statementName: StatementName,
    workGroup: WorkGroupName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest = {
    import GetPreparedStatementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest
      .builder()
      .statementName(StatementName.unwrap(statementName): java.lang.String)
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetPreparedStatementRequest.ReadOnly =
    zio.aws.athena.model.GetPreparedStatementRequest.wrap(buildAwsValue())
}
object GetPreparedStatementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetPreparedStatementRequest =
      zio.aws.athena.model.GetPreparedStatementRequest(statementName, workGroup)
    def statementName: StatementName
    def workGroup: WorkGroupName
    def getStatementName: ZIO[Any, Nothing, StatementName] =
      ZIO.succeed(statementName)
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest
  ) extends zio.aws.athena.model.GetPreparedStatementRequest.ReadOnly {
    override val statementName: StatementName =
      zio.aws.athena.model.primitives.StatementName(impl.statementName())
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetPreparedStatementRequest
  ): zio.aws.athena.model.GetPreparedStatementRequest.ReadOnly = new Wrapper(
    impl
  )
}
