package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetPreparedStatementResponse(
    preparedStatement: Option[zio.aws.athena.model.PreparedStatement] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse = {
    import GetPreparedStatementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse
      .builder()
      .optionallyWith(preparedStatement.map(value => value.buildAwsValue()))(
        _.preparedStatement
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly =
    zio.aws.athena.model.GetPreparedStatementResponse.wrap(buildAwsValue())
}
object GetPreparedStatementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetPreparedStatementResponse =
      zio.aws.athena.model.GetPreparedStatementResponse(
        preparedStatement.map(value => value.asEditable)
      )
    def preparedStatement
        : Option[zio.aws.athena.model.PreparedStatement.ReadOnly]
    def getPreparedStatement
        : ZIO[Any, AwsError, zio.aws.athena.model.PreparedStatement.ReadOnly] =
      AwsError.unwrapOptionField("preparedStatement", preparedStatement)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse
  ) extends zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly {
    override val preparedStatement
        : Option[zio.aws.athena.model.PreparedStatement.ReadOnly] = scala
      .Option(impl.preparedStatement())
      .map(value => zio.aws.athena.model.PreparedStatement.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetPreparedStatementResponse
  ): zio.aws.athena.model.GetPreparedStatementResponse.ReadOnly = new Wrapper(
    impl
  )
}
