package zio.aws.athena.model
import zio.aws.athena.model.primitives.QueryExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetQueryExecutionRequest(queryExecutionId: QueryExecutionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest = {
    import GetQueryExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest
      .builder()
      .queryExecutionId(
        QueryExecutionId.unwrap(queryExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetQueryExecutionRequest.ReadOnly =
    zio.aws.athena.model.GetQueryExecutionRequest.wrap(buildAwsValue())
}
object GetQueryExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetQueryExecutionRequest =
      zio.aws.athena.model.GetQueryExecutionRequest(queryExecutionId)
    def queryExecutionId: QueryExecutionId
    def getQueryExecutionId: ZIO[Any, Nothing, QueryExecutionId] =
      ZIO.succeed(queryExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest
  ) extends zio.aws.athena.model.GetQueryExecutionRequest.ReadOnly {
    override val queryExecutionId: QueryExecutionId =
      zio.aws.athena.model.primitives.QueryExecutionId(impl.queryExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetQueryExecutionRequest
  ): zio.aws.athena.model.GetQueryExecutionRequest.ReadOnly = new Wrapper(impl)
}
