package zio.aws.athena.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetQueryExecutionResponse(
    queryExecution: Option[zio.aws.athena.model.QueryExecution] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse = {
    import GetQueryExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse
      .builder()
      .optionallyWith(queryExecution.map(value => value.buildAwsValue()))(
        _.queryExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetQueryExecutionResponse.ReadOnly =
    zio.aws.athena.model.GetQueryExecutionResponse.wrap(buildAwsValue())
}
object GetQueryExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetQueryExecutionResponse =
      zio.aws.athena.model.GetQueryExecutionResponse(
        queryExecution.map(value => value.asEditable)
      )
    def queryExecution: Option[zio.aws.athena.model.QueryExecution.ReadOnly]
    def getQueryExecution
        : ZIO[Any, AwsError, zio.aws.athena.model.QueryExecution.ReadOnly] =
      AwsError.unwrapOptionField("queryExecution", queryExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse
  ) extends zio.aws.athena.model.GetQueryExecutionResponse.ReadOnly {
    override val queryExecution
        : Option[zio.aws.athena.model.QueryExecution.ReadOnly] = scala
      .Option(impl.queryExecution())
      .map(value => zio.aws.athena.model.QueryExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetQueryExecutionResponse
  ): zio.aws.athena.model.GetQueryExecutionResponse.ReadOnly = new Wrapper(impl)
}
