package zio.aws.athena.model
import zio.aws.athena.model.primitives.Token
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetQueryResultsResponse(
    updateCount: Option[Long] = None,
    resultSet: Option[zio.aws.athena.model.ResultSet] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetQueryResultsResponse = {
    import GetQueryResultsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetQueryResultsResponse
      .builder()
      .optionallyWith(updateCount.map(value => value: java.lang.Long))(
        _.updateCount
      )
      .optionallyWith(resultSet.map(value => value.buildAwsValue()))(
        _.resultSet
      )
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetQueryResultsResponse.ReadOnly =
    zio.aws.athena.model.GetQueryResultsResponse.wrap(buildAwsValue())
}
object GetQueryResultsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetQueryResultsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetQueryResultsResponse =
      zio.aws.athena.model.GetQueryResultsResponse(
        updateCount.map(value => value),
        resultSet.map(value => value.asEditable),
        nextToken.map(value => value)
      )
    def updateCount: Option[Long]
    def resultSet: Option[zio.aws.athena.model.ResultSet.ReadOnly]
    def nextToken: Option[Token]
    def getUpdateCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("updateCount", updateCount)
    def getResultSet
        : ZIO[Any, AwsError, zio.aws.athena.model.ResultSet.ReadOnly] =
      AwsError.unwrapOptionField("resultSet", resultSet)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetQueryResultsResponse
  ) extends zio.aws.athena.model.GetQueryResultsResponse.ReadOnly {
    override val updateCount: Option[Long] =
      scala.Option(impl.updateCount()).map(value => value: Long)
    override val resultSet: Option[zio.aws.athena.model.ResultSet.ReadOnly] =
      scala
        .Option(impl.resultSet())
        .map(value => zio.aws.athena.model.ResultSet.wrap(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.athena.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetQueryResultsResponse
  ): zio.aws.athena.model.GetQueryResultsResponse.ReadOnly = new Wrapper(impl)
}
