package zio.aws.athena.model
import zio.aws.athena.model.primitives.{NameString, CatalogNameString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetTableMetadataRequest(
    catalogName: CatalogNameString,
    databaseName: NameString,
    tableName: NameString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetTableMetadataRequest = {
    import GetTableMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetTableMetadataRequest
      .builder()
      .catalogName(CatalogNameString.unwrap(catalogName): java.lang.String)
      .databaseName(NameString.unwrap(databaseName): java.lang.String)
      .tableName(NameString.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetTableMetadataRequest.ReadOnly =
    zio.aws.athena.model.GetTableMetadataRequest.wrap(buildAwsValue())
}
object GetTableMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetTableMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetTableMetadataRequest =
      zio.aws.athena.model
        .GetTableMetadataRequest(catalogName, databaseName, tableName)
    def catalogName: CatalogNameString
    def databaseName: NameString
    def tableName: NameString
    def getCatalogName: ZIO[Any, Nothing, CatalogNameString] =
      ZIO.succeed(catalogName)
    def getDatabaseName: ZIO[Any, Nothing, NameString] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, NameString] = ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetTableMetadataRequest
  ) extends zio.aws.athena.model.GetTableMetadataRequest.ReadOnly {
    override val catalogName: CatalogNameString =
      zio.aws.athena.model.primitives.CatalogNameString(impl.catalogName())
    override val databaseName: NameString =
      zio.aws.athena.model.primitives.NameString(impl.databaseName())
    override val tableName: NameString =
      zio.aws.athena.model.primitives.NameString(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetTableMetadataRequest
  ): zio.aws.athena.model.GetTableMetadataRequest.ReadOnly = new Wrapper(impl)
}
