package zio.aws.athena.model
import zio.aws.athena.model.primitives.WorkGroupName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetWorkGroupRequest(workGroup: WorkGroupName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.athena.model.GetWorkGroupRequest = {
    import GetWorkGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.athena.model.GetWorkGroupRequest
      .builder()
      .workGroup(WorkGroupName.unwrap(workGroup): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.athena.model.GetWorkGroupRequest.ReadOnly =
    zio.aws.athena.model.GetWorkGroupRequest.wrap(buildAwsValue())
}
object GetWorkGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.athena.model.GetWorkGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.athena.model.GetWorkGroupRequest =
      zio.aws.athena.model.GetWorkGroupRequest(workGroup)
    def workGroup: WorkGroupName
    def getWorkGroup: ZIO[Any, Nothing, WorkGroupName] = ZIO.succeed(workGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.athena.model.GetWorkGroupRequest
  ) extends zio.aws.athena.model.GetWorkGroupRequest.ReadOnly {
    override val workGroup: WorkGroupName =
      zio.aws.athena.model.primitives.WorkGroupName(impl.workGroup())
  }
  def wrap(
      impl: software.amazon.awssdk.services.athena.model.GetWorkGroupRequest
  ): zio.aws.athena.model.GetWorkGroupRequest.ReadOnly = new Wrapper(impl)
}
